<?php namespace DistrictHub\Directory\Listeners;

use DistrictHub\Directory\Events\MemberRemovedFromRole;
use DistrictHub\Support\Listeners\Notification;

class AlertMemberRemovedFromRole extends Notification
{
    /**
     * Handle the event.
     *
     * @param  MemberRemovedFromRole $event
     *
     * @return void
     */
    public function handle(MemberRemovedFromRole $event)
    {
        $this->notifier->success("Removed Member \"{$event->member->name}\" from Role \"{$event->role->name}\"");
    }
}
