<?php namespace DistrictHub\Groups\Events;

use DistrictHub\Directory\Member;
use DistrictHub\Groups\Group;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class MemberLinkedToGroup
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    public $member, $group;

    /**
     * Create a new event instance.
     *
     * @param Member $member
     * @param Group  $group
     *
     * @return void
     */
    public function __construct(Member $member, Group $group)
    {
        $this->member = $member;
        $this->group = $group;
    }
}
