<?php namespace DistrictHub\Groups\Http\Controllers;

use DistrictHub\Directory\Member;
use DistrictHub\Groups\Group;
use DistrictHub\Groups\Post;
use App\Http\Controllers\Controller;
use Illuminate\Contracts\Auth\Authenticatable;

class PostController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @return Response
     */
    public function store($groupId, Authenticatable $user, \DistrictHub\Groups\Http\Requests\PostRequest $request)
    {
        $group = Group::find($groupId);
        $member = Member::find($user->member_id);

        $post = Post::create([
            'author'     => $member->name,
            'content'    => $request->input('content'),
            'attachment' => $request->file('attachment'),
        ]);

        $post->group()->associate($group);
        $post->member()->associate($member);

        $post->save();

        return redirect()->back();
    }

    /**
     * Display the specified resource.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function update($id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function destroy($groupId, $postId)
    {
        Post::destroy($postId);

        return redirect()->back();
    }

}
