<?php namespace DistrictHub\Groups\Jobs;

use DistrictHub\Directory\Member;
use DistrictHub\Groups\Events\MemberLinkedToGroup;
use DistrictHub\Groups\Group;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class LinkMemberToGroup implements ShouldQueue
{
    use InteractsWithQueue, Queueable, SerializesModels;

    protected $memberId, $groupId, $roleId;

    /**
     * Create a new command instance.
     *
     * @param int $memberId
     * @param int $groupId
     * @param int $roleId
     *
     * @return void
     */
    public function __construct($memberId, $groupId, $roleId)
    {
        $this->memberId = $memberId;
        $this->groupId = $groupId;
        $this->roleId = $roleId;
    }

    /**
     * Execute the command.
     *
     * @return void
     */
    public function handle()
    {
        $group = Group::find($this->groupId);

        $group->members()->attach($this->memberId, ['role_id' => $this->roleId]);

        $group->touch();

        $member = Member::find($this->memberId);

        event(new MemberLinkedToGroup($member, $group));
    }
}
