<?php namespace DistrictHub\Groups\Listeners;

use DistrictHub\Groups\Events\GroupWasCreated;
use DistrictHub\Support\Listeners\Notification;

class AlertGroupCreated extends Notification
{
    /**
     * Handle the event.
     *
     * @param  GroupWasCreated $event
     *
     * @return void
     */
    public function handle(GroupWasCreated $event)
    {
        $url = route('groups.edit', [$event->group->id]);
        $this->notifier->success("Created Group \"<a href=\"{$url}\">{$event->group->name}</a>\"");
    }
}
