@extends('app')

@section('title')
    <h2>
        {{ $group->name }}
        <a class="btn btn-default pull-right" href="{{ route('groups.show', ['id' => $group->id]) }}">
            <i class="fa fa-eye"></i>
            View Group
        </a>
    </h2>
@stop

@section('breadcrumbs')
    <ol class="breadcrumb breadcrumb-plain flush-bottom">
        <li><a href="/"><i class="fa fa-home visible-xs"></i> <span class="hidden-xs">Dashboard</span></a></li>
        <li><a href="{{ route('groups.index') }}">Groups</a></li>
        <li class="active">{{ $group->name }}</li>
    </ol>
@stop

@section('content')
    <div class="panel panel-default">
        <div class="panel-heading">Group Details</div>
        <div class="panel-body">
            @include('groups::panels.group-details')
        </div>
    </div>

    <div class="panel panel-default">
        <div class="panel-heading">Member Details</div>
        <div class="panel-body">
            @include('groups::panels.member-details')
        </div>
        <div class="table-responsive">
            <table class="table table table-striped table-bordered table-hover display" cellspacing="0" width="100%">
                <thead>
                <tr>
                    <th>First Name</th>
                    <th>Last Name</th>
                    <th>Circuit</th>
                    <th>Role</th>
                    <th></th>
                </tr>
                </thead>

                @foreach($group->members as $member)
                    <tr>
                        <td>{{ $member->first_name }}</td>
                        <td>{{ $member->last_name }}</td>
                        <td>{{ $member->circuit->name }}</td>
                        <td>{{ $roles[$member->pivot->role_id] }}</td>
                        <td data-display="{{ $member->id }}">
                            <a class="btn btn-default btn-xs" href="{{ route('members.show', [$member->id]) }}"data-toggle="tooltip" data-placement="top" title="View member">
                                <i class="fa fa-eye"></i>
                            </a>
                            <a class="btn btn-default btn-xs" href="{{ route('members.edit', [$member->id]) }}"data-toggle="tooltip" data-placement="top" title="Edit member">
                                <i class="fa fa-pencil"></i>
                            </a>
                            <a class="btn btn-default btn-xs" href="{{ route('groups.members.unlink', [$group->id, $member->id]) }}" data-toggle="tooltip" data-placement="top" title="Unlink member">
                                <i class="fa fa-chain-broken"></i>
                            </a>
                        </td>
                    </tr>
                @endforeach
            </table>
        </div>
    </div>
@endsection

@section('scripts')
    <script>
        $('#member_id').selectize({
            maxItems: 1,
            valueField: 'id',
            labelField: 'name',
            searchField: 'name',
            sortField: 'name',
            create: false,
            render: {
                option: function (item, escape) {
                    return '<div>' +
                            '<span class="">' + escape(item.name) + '</span><br>' +
                            '</div>';
                }
            },
            load: function (query, callback) {
                if(!query.length) return callback();
                $.ajax({
                    url: '{{ route('api.members.index') }}',
                    type: 'GET',
                    dataType: 'json',
                    error: function () {
                        callback();
                    },
                    success: function (response) {
                        callback(response.data)
                    }
                });
            }
        });

        $('[data-toggle="tooltip"]').tooltip();
    </script>
@stop