<?php namespace DistrictHub\Groups\Jobs;

use DistrictHub\Groups\Events\GroupWasCreated;
use DistrictHub\Groups\Group;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class CreateGroup implements ShouldQueue
{
    use InteractsWithQueue, Queueable, SerializesModels;

    protected $name, $description, $creatorMemberId;

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct($name, $description, $creatorMemberId)
    {
        $this->name = $name;
        $this->description = $description;
        $this->creatorMemberId = $creatorMemberId;
    }

    /**
     * Execute the command.
     *
     * @return void
     */
    public function handle()
    {
        $group = Group::create(
            [
                'name'        => $this->name,
                'description' => $this->description,
            ]
        );

        $group->members()->attach($this->creatorMemberId, ['role_id' => 1]);

        event(new GroupWasCreated($group));
    }
}
