<?php namespace DistrictHub\Groups\Jobs;

use DistrictHub\Directory\Member;
use DistrictHub\Groups\Events\MemberUnlinkedFromGroup;
use DistrictHub\Groups\Group;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class UnlinkMemberFromGroup implements ShouldQueue
{
    use InteractsWithQueue, Queueable, SerializesModels;

    protected $memberId, $groupId;

    /**
     * Create a new command instance.
     *
     * @param int $memberId
     * @param int $groupId
     *
     * @return void
     */
    public function __construct($memberId, $groupId)
    {
        $this->memberId = $memberId;
        $this->groupId = $groupId;
    }

    /**
     * Execute the command.
     *
     * @return void
     */
    public function handle()
    {
        $group = Group::find($this->groupId);

        $group->members()->detach($this->memberId);

        $group->touch();

        $member = Member::find($this->memberId);

        event(new MemberUnlinkedFromGroup($member, $group));
    }
}
