<?php namespace DistrictHub\Groups\Listeners;

use DistrictHub\Groups\Events\MemberLinkedToGroup;
use DistrictHub\Support\Listeners\Notification;

class AlertMemberLinkedToGroup extends Notification
{
    /**
     * Handle the event.
     *
     * @param  MemberLinkedToGroup $event
     *
     * @return void
     */
    public function handle(MemberLinkedToGroup $event)
    {
        $this->notifier->success("Linked Member \"{$event->member->name}\" to Group \"{$event->group->name}\"");
    }
}
