<?php namespace DistrictHub\Groups\Providers;

use DistrictHub\Groups\Events\GroupWasCreated;
use DistrictHub\Groups\Events\GroupWasUpdated;
use DistrictHub\Groups\Events\MemberLinkedToGroup;
use DistrictHub\Groups\Events\MemberUnlinkedFromGroup;
use DistrictHub\Groups\Listeners\AlertGroupCreated;
use DistrictHub\Groups\Listeners\AlertGroupUpdated;
use DistrictHub\Groups\Listeners\AlertMemberLinkedToGroup;
use DistrictHub\Groups\Listeners\AlertMemberUnlinkedFromGroup;
use Illuminate\Foundation\Support\Providers\EventServiceProvider as ServiceProvider;

class EventServiceProvider extends ServiceProvider
{
    /**
     * The event handler mappings for the application.
     *
     * @var array
     */
    protected $listen = [
        GroupWasCreated::class         => [
            AlertGroupCreated::class,
        ],
        GroupWasUpdated::class         => [
            AlertGroupUpdated::class,
        ],
        MemberLinkedToGroup::class     => [
            AlertMemberLinkedToGroup::class,
        ],
        MemberUnlinkedFromGroup::class => [
            AlertMemberUnlinkedFromGroup::class,
        ],
    ];
}
