<?php namespace DistrictHub\Groups\Jobs;

use DistrictHub\Groups\Events\GroupWasUpdated;
use DistrictHub\Groups\Group;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class UpdateGroup implements ShouldQueue
{
    use InteractsWithQueue, Queueable, SerializesModels;

    protected $id, $name, $description, $contribute, $membership_list;

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct($id, $name, $description, $contribute, $membership_list)
    {
        $this->id = $id;
        $this->name = $name;
        $this->description = $description;
        $this->contribute = $contribute;
        $this->membership_list = $membership_list;
    }

    /**
     * Execute the command.
     *
     * @return void
     */
    public function handle()
    {
        $group = Group::find($this->id);

        $group->name = $this->name;
        $group->description = $this->description;
        $group->contribute = $this->contribute;
        $group->membership_list = $this->membership_list;

        $group->save();

        event(new GroupWasUpdated($group));
    }
}
