<?php namespace DistrictHub\Groups\Listeners;

use DistrictHub\Groups\Events\MemberUnlinkedFromGroup;
use DistrictHub\Support\Listeners\Notification;

class AlertMemberUnlinkedFromGroup extends Notification
{
    /**
     * Handle the event.
     *
     * @param  MemberUnlinkedFromGroup $event
     *
     * @return void
     */
    public function handle(MemberUnlinkedFromGroup $event)
    {
        $this->notifier->success("Unlinked Member \"{$event->member->name}\" from Group \"{$event->group->name}\"");
    }
}
