@extends('app')

@section('title')
    <h2>
        {{ $group->name }}
        @if(Auth::user()->adminOf($group->id))
        <div class="btn-group pull-right">
            <a class="btn btn-default" href="{{ route('groups.edit', ['id' => $group->id]) }}">
                <i class="fa fa-pencil"></i>
                Edit Group
            </a>
            <button type="button" class="btn btn-default dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                <span class="caret"></span>
                <span class="sr-only">Toggle Dropdown</span>
            </button>
            <ul class="dropdown-menu">
                <li>
                    <a href="{{ route('groups.compose', $group->id) }}" data-toggle="modal" data-target="#modal">Message Group</a>
                </li>
            </ul>
        </div>
        @endif
    </h2>
@stop

@section('breadcrumbs')
    <ol class="breadcrumb breadcrumb-plain flush-bottom">
        <li><a href="/"><i class="fa fa-home visible-xs"></i> <span class="hidden-xs">Dashboard</span></a></li>
        <li><a href="{{ route('groups.index') }}">Groups</a></li>
        <li class="active">{{ $group->name }}</li>
    </ol>
@stop

@section('content')
    @if(isset($group->description))
    <p>{{ $group->description }}</p>
    @endif

    <div role="tabpanel">
        <!-- Nav tabs -->
        <ul class="nav nav-tabs nav-tabs-panel" role="tablist">
            <li role="presentation" class="active"><a href="#group-posts" aria-controls="group-posts" role="tab" data-toggle="tab">Posts</a></li>
            @if($group->membership_list)
            <li role="presentation"><a href="#group-members" aria-controls="group-members" role="tab" data-toggle="tab">Members</a></li>
            @endif
        </ul>
        <!-- Tab panes -->
        <div class="tab-content">
            <div role="tabpanel" class="tab-pane active" id="group-posts">
                <div class="panel panel-tab-pane">
                    @if(Auth::user()->memberOf($group->id) && $group->contribute)
                    <div class="panel-body bg-default">
                        {!! Form::open(['files' => true, 'method' => 'POST', 'route' => ['groups.posts.store', $group->id]]) !!}
                        <div class="form-group{{ $errors->has('content') ? ' has-error' : '' }}">
                            {!! Form::textarea('content', null, ['id' => 'post-content', 'class' => 'form-control', 'placeholder' => 'What would you like to say?', 'rows' => '1']) !!}
                            @if($errors->has('content'))
                                <span class="text-danger">{{ $errors->first('content') }}</span>
                            @endif
                        </div>
                        {!! Form::button('Post', ['class' => 'btn btn-primary', 'type' => 'submit']) !!}
                        <div class="fileinput fileinput-new" data-provides="fileinput">
                            <span class="btn btn-default btn-file">
                                <span class="fileinput-new">Attach file</span>
                                <span class="fileinput-exists">Change file</span>
                                {!! Form::file('attachment') !!}
                            </span>
                            <span class="fileinput-filename"></span>
                            <a href="#" class="fileinput-exists" data-dismiss="fileinput" style="float: none"><i class="fa fa-times"></i></a>
                        </div>
                        {!! Form::close() !!}
                    </div>
                    @endif

                    @include('groups::lists.posts')

                    @if($posts->count() > 5)
                    <div id="group-posts-navigation" class="panel-footer panel-pagination">
                        <div class="row">
                            <div class="col-sm-5">
                                <p class="page-count">
                                    Showing {{ ($posts->currentPage() * $posts->perPage()) - $posts->perPage() + 1 }}
                                    to {{ $posts->currentPage() * $posts->perPage() }}
                                    of {{ $posts->total() }}
                                </p>
                            </div>
                            <div class="col-sm-7 text-right">
                                {!! $posts->render() !!}
                            </div>
                        </div>
                    </div>
                    @endif
                </div>
            </div>
            @if($group->membership_list)
            <div role="tabpanel" class="tab-pane" id="group-members">
                <div class="panel panel-tab-pane">
                    <div class="table-responsive">
                        <table class="table table table-striped display" cellspacing="0" width="100%">
                            <thead>
                            <tr>
                                <th>First Name</th>
                                <th>Last Name</th>
                                <th>Circuit</th>
                                <th>Role</th>
                                <th></th>
                            </tr>
                            </thead>

                            @foreach($members as $member)
                                <tr>
                                    <td>{{ $member->first_name }}</td>
                                    <td>{{ $member->last_name }}</td>
                                    <td>{{ $member->circuit->name }}</td>
                                    <td>{{ $roles[$member->pivot->role_id] }}</td>
                                    <td>
                                        <a class="btn btn-default btn-xs" href="{{ route('members.show', ['id' => $member->id]) }}" data-toggle="tooltip" data-placement="top" title="View member">
                                            <i class="fa fa-eye"></i>
                                        </a>
                                    </td>
                                </tr>
                            @endforeach
                        </table>
                    </div>
                </div>
            </div>
            @endif
        </div>
    </div>
@endsection

@section('scripts')
    <script>
        $('#post-content')
            .on('focusin', function () {
                $(this).attr('rows', 10);
            })
            .on('focusout', function () {
                    var $this = $(this);

                    if($this.val().length === 0) {
                        $this.attr('rows', 1);
                    }
            });

        $.extend($.infinitescroll.prototype, {
            _showdonemsg_bootstrap: function () {
                var opts = this.options;

                opts.loading.msg
                        .html(opts.loading.finishedMsg).animate({ opacity: 1 }, 2000, function () {
                            $(this).fadeOut(opts.loading.speed);
                        });

                // user provided callback when done
                opts.errorCallback.call($(opts.contentSelector)[0],'done');
            }
        });

        $('#group-posts-list').infinitescroll({
            navSelector  : "#group-posts-navigation",
            nextSelector : "#group-posts-navigation ul.pagination li:last-child a:first",
            itemSelector : "#group-posts-list li.list-group-item",
            prefill: true,
            bufferPx: 100,
            loading: {
                msg: $('<li id="infscr-loading" class="list-group-item"><div class="progress"><div class="progress-bar progress-bar-striped active" role="progressbar" aria-valuenow="100" aria-valuemin="0" aria-valuemax="100" style="width: 100%"><span class="sr-only">Loading...</span></div></div></li>'),
                finishedMsg: 'No more content to load!'
            },
            behavior: 'bootstrap'
        }, function(arrayOfNewElems){
            $(this)
                .linkify()
                .find('[data-toggle="tooltip"]').tooltip();
        });

        $('[data-toggle="tooltip"]').tooltip();
    </script>
@endsection
