<?php

/*
|--------------------------------------------------------------------------
| Application Routes
|--------------------------------------------------------------------------
|
| Here is where you can register all of the routes for an application.
| It's a breeze. Simply tell Laravel the URIs it should respond to
| and give it the controller to call when that URI is requested.
|
*/

Route::get('groups/{groups}/message', ['as' => 'groups.compose', 'uses' => 'GroupController@compose']);
Route::post('groups/{groups}/message', ['as' => 'groups.message', 'uses' => 'GroupController@message']);

Route::resources([
    'groups'       => 'GroupController',
    'groups.posts' => 'PostController',
]);

Route::get(
    'groups/{groups}/delete',
    ['as' => 'groups.delete', 'uses' => 'GroupController@delete']
);

Route::patch(
    'groups/{groups}/members',
    ['as' => 'groups.members.link', 'uses' => 'GroupController@linkMember']
);

Route::get(
    'groups/{groups}/members/{members}',
    ['as' => 'groups.members.unlink', 'uses' => 'GroupController@unlinkMember']
);

Route::get(
    'groups/{groups}/join',
    ['as' => 'groups.join', 'uses' => 'GroupController@joinGroup']
);

Route::get(
    'groups/{groups}/leave',
    ['as' => 'groups.leave', 'uses' => 'GroupController@leaveGroup']
);

Route::get(
    'groups/{groups}/subscribe',
    ['as' => 'groups.subscribe', 'uses' => 'GroupController@subscribeToGroup']
);
