@if($posts->count() > 0)
<ul id="group-posts-list" class="list-group">
    @foreach($posts as $post)
    <li class="list-group-item">
        <h4 class="list-group-item-heading">
            {{ $post->author }}
            <small>
                <span data-livestamp="{{ $post->created_at->timestamp }}">{{ $post->created_at->diffForHumans() }}</span>
                @if(Auth::user()->member_id === $post->member_id)
                    {!! Form::open(['class' => 'pull-right', 'method' => 'POST', 'route' => ['groups.posts.destroy', $group->id, $post->id]]) !!}
                        {!! Form::hidden('_method', 'DELETE') !!}
                        {!! Form::button('<i class="fa fa-trash"></i>', ['class' => 'btn btn-danger btn-xs', 'type' => 'submit', 'data-toggle' => 'tooltip', 'data-placement' => 'top', 'title' => 'Remove post']) !!}
                    {!! Form::close() !!}
                @endif
            </small>
        </h4>
        <p class="list-group-item-text" data-linkify="this">{{ $post->content }}</p>
        @if($post->attachment->originalFilename())
        <div>
            <i class="fa fa-paperclip"></i>
            <a href="{{ $post->attachment->url() }}" target="_blank">{{ $post->attachment->originalFilename() }}</a>
            ({{ $post->attachment_size }})
        </div>
        @endif
    </li>
    @endforeach
</ul>
@else
    <p class="text-center">No posts</p>
@endif
