@extends('app')

@section('title')
    <h2>
        Groups
        @if(Auth::user()->ability('district-admin', 'create-group'))
            <a class="btn btn-default pull-right" href="{{ route('groups.create') }}">
                <i class="fa fa-plus-circle"></i>
                Add Group
            </a>
        @endif
    </h2>
@stop

@section('breadcrumbs')
    <ol class="breadcrumb breadcrumb-plain flush-bottom">
        <li><a href="/"><i class="fa fa-home visible-xs"></i> <span class="hidden-xs">Dashboard</span></a></li>
        <li class="active">Groups</li>
    </ol>
@stop

@section('content')
    <div class="row">
        @foreach($groups as $group)
            <div class="col-md-6 col-lg-4">
                <div class="panel panel-info">
                    <div class="panel-heading">
                        <div class="row">
                            <div class="col-xs-8">
                                <h3>{{ $group->name }}</h3>
                            </div>
                            <div class="col-xs-4 text-right">
                                <div class="huge">{{ $group->members()->wherePivot('role_id', '<>', 3)->count() }}</div>
                                <div>Members</div>
                            </div>
                        </div>
                    </div>
                    <div class="panel-footer">
                        @if(Auth::user()->adminOf($group->id))
                            <div class="btn-group">
                                <a class="btn btn-info" href="{{ route('groups.show', [$group->id]) }}">
                                    <i class="fa fa-eye"></i>
                                    View
                                </a>
                                <button type="button" class="btn btn-info dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                    <span class="caret"></span>
                                    <span class="sr-only">Toggle Dropdown</span>
                                </button>
                                <ul class="dropdown-menu">
                                    <li>
                                        <a href="{{ route('groups.edit', [$group->id]) }}">
                                            <i class="fa fa-pencil"></i>
                                            Edit
                                        </a>
                                    </li>
                                    <li>
                                        <a href="{{ route('groups.delete', ['id' => $group->id]) }}" data-toggle="modal" data-target="#modal">
                                            <i class="fa fa-trash"></i>
                                            Delete
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        @else
                            <a class="btn btn-info" href="{{ route('groups.show', [$group->id]) }}">
                                <i class="fa fa-eye"></i>
                                View
                            </a>
                        @endif
                        @if(Auth::user()->memberOf($group->id))
                            <a class="btn btn-default" href="{{ route('groups.leave', [$group->id]) }}">
                                <i class="fa fa-sign-out"></i>
                                Leave
                            </a>
                        @else
                            @if(Auth::user()->subscriberOf($group->id))
                                <a class="btn btn-default" href="{{ route('groups.leave', [$group->id]) }}">
                                    <i class="fa fa-close"></i>
                                    Unsubscribe
                                </a>
                            @else
                                <a class="btn btn-default" href="{{ route('groups.subscribe', [$group->id]) }}">
                                    <i class="fa fa-rss"></i>
                                    Subscribe
                                </a>
                            @endif
                        @endif
                    </div>
                </div>
            </div>
        @endforeach
    </div>
@endsection

@section('scripts')
    <script>
        $('.col-md-6').matchHeight();
    </script>
@stop
