<?php namespace DistrictHub\Groups;

/**
 * Attachment.
 *
 * @author       Tom Densham <tom.densham@studiobonito.co.uk>
 * @copyright    Studio Bonito Ltd.
 * @package      App
 */
class Attachment
{
    private $fieldName;

    private $fileName;

    private $fileSize;

    private $contentType;

    private $updatedAt;

    /**
     * @param        $fieldName
     * @param string $fileName
     * @param int    $fileSize
     * @param string $contentType
     * @param string $updatedAt
     */
    public function __construct($fieldName, $fileName, $fileSize, $contentType, $updatedAt)
    {
        $this->fieldName = $fieldName;
        $this->fileName = $fileName;
        $this->fileSize = $fileSize;
        $this->contentType = $contentType;
        $this->updatedAt = $updatedAt;
    }

    /**
     * Return original filename.
     *
     * @return string
     */
    public function originalFilename()
    {
        return $this->fileName;
    }

    /**
     * Return url for image.
     *
     * @param string $size
     *
     * @return string
     */
    public function url($size = 'original')
    {
        $contentType = explode('/', $this->contentType);

        $type = isset($contentType[0]) && !empty($contentType[0]) ? $contentType[0] : 'image';

        if (empty($this->fileName)) {
            switch ($size) {
                case 'medium':
                case 'thumb':
                    return url($type . 's/' . $this->fieldName . '/medium/missing.png');
                default:
                    return '';
            }
        }

        return '//s3-' . config('filesystems.disks.s3.region') . '.amazonaws.com/'
               . config('filesystems.disks.s3.bucket') . '/' . $type . 's/' . $this->fieldName . '/' . $size . '/'
               . $this->fileName;
    }

    /**
     * Return file size for image.
     *
     * @return int
     */
    public function size()
    {
        return $this->fileSize;
    }
}
