<?php namespace DistrictHub\Groups\Console\Commands;

use DistrictHub\Directory\Member;
use DistrictHub\Groups\Post;
use Illuminate\Console\Command;

class PopulateGroupPostAuthors extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'populate:authors';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Populate author field for group posts from member details.';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        $this->info('Populating authors:');

        $posts = Post::all();

        $postsCount = count($posts);

        if ($postsCount === 0) {
            $this->comment('No posts to populate.');

            return;
        }

        $progressBar = $this->output->createProgressBar($postsCount);

        $posts->each(
            function (Post $post) use ($progressBar) {
                $member = Member::find($post->member_id);

                if(!is_null($member)) {
                    $post->author = $member->name;
                    $post->save();
                }

                $progressBar->advance();
            }
        );

        $progressBar->finish();

        // TODO: Remove newline hack
        $this->comment("\nPopulated {$postsCount} authors.");
    }
}
