<?php

class EventListPage extends Page
{
    /**
     * Human-readable singular name. See {@link DataObject::$singular_name}
     * @var string
     */
    public static $singular_name = 'Event List page';

    /**
     * Human-readable pluaral name. See {@link DataObject::$plural_name}
     * @var string
     */
    public static $plural_name = 'Event Page Lists';

    /**
     * Human-readable description of Page. See {@link DataObject::$description}
     *
     * @access public
     * @static
     * @var string
     */
    public static $description = 'List of Event pages';

    //public static $icon = 'articles/images/article-holder.png';

     public static $allowed_children = array(
         'EventPage'
     );

    /**
     * List of database fields. {@link DataObject::$db}
     *
     * @var array
     */
    public static $db = array(
        'PageLength' => 'Int'
    );


    public static $defaults = array(
        'PageLength' => 10
    );

    /**
     * Returns a FieldList with which to create the editing form. {@link SiteTree::getCMSFields()}
     *
     * @return FieldList
     */
    public function getCMSFields()
    {
        $fields = parent::getCMSFields();

        return $fields;
    }

    public function getSettingsFields()
    {
        $fields = parent::getSettingsFields();
        $pageLengthNumericField = new NumericField('PageLength', 'Page length');
        $pageLengthNumericField->setDescription('Number of child pages to display per page.');
        $fields->addFieldToTab('Root.Settings', $pageLengthNumericField);
        return $fields;
    }
}

class EventListPage_Controller extends Page_Controller
{

    protected $order = 'ASC';
    protected $startDate = null;
    protected $endDate = null;
    protected $textSearch = null;
    protected $dateComparison = '>=';

    public function init() {
        parent::init();
    }

    private static $allowed_actions = array (
        'archive',
        'EventSearchForm'
    );

    public function Children()
    {
        if(((int)$this->PageLength) > 0) {
            $children = SiteTree::get()->filter(array('ParentID' => $this->ID));
            $childrenPaginatedList = new PaginatedList($children, $this->request);
            $childrenPaginatedList->setPageLength($this->PageLength);
            return $childrenPaginatedList;
        }
        return parent::Children();
    }

    public function Events()
    {
        if(((int)$this->PageLength) > 0) {

            $params = $this->request->params();
            if($params['Action'] == 'archive')
            {
                $this->order = "DESC";
                $this->dateComparison = "<";
            }

            $filter = array( 'ParentID' => $this->ID);
            $where = '"StartDate" '.$this->dateComparison.' CURDATE()';

            if($title = $this->request->getVar('Title'))
            {
                $filter['Title:PartialMatch'] = $title;
            }

            if($themeID = $this->request->getVar('ThemeID'))
            {
                $filter['ThemeID'] = $themeID;
            }

            if($typeID = $this->request->getVar('TypeID'))
            {
                $filter['TypeID'] = $typeID;
            }

            if($this->request->getVar('StartDate') AND $this->request->getVar('EndDate'))
            {
                $startDate = DateTime::createFromFormat('d M Y', $this->request->getVar('StartDate'));
                $endDate = DateTime::createFromFormat('d M Y', $this->request->getVar('EndDate'));
                $where = "DATE(StartDate) BETWEEN '".date_format($startDate, 'Y-m-d')."' and '".date_format($endDate, 'Y-m-d')."'";
            } else {
                if($startDate = $this->request->getVar('StartDate'))
                {
                    $date = DateTime::createFromFormat('d M Y', $this->request->getVar('StartDate'));
                    $where = "DATE(StartDate) = '".date_format($date, 'Y-m-d')."'";
                }

                if($this->request->getVar('EndDate'))
                {
                    $date = DateTime::createFromFormat('d M Y', $this->request->getVar('EndDate'));
                    $where = "DATE(EndDate) = '".date_format($date, 'Y-m-d')."'";
                }
            }


            $children = EventPage::get()
                ->where($where)
                ->filter($filter)
                ->sort('StartDate', $this->order);

            $childrenPaginatedList = new PaginatedList($children, $this->request);
            $childrenPaginatedList->setPageLength($this->PageLength);
            return $childrenPaginatedList;
        }
    }

    public function EventSearchForm()
    {
        $form = new EventSearchForm($this, 'EventSearchForm');

        $data = [
            'Title' => $this->request->getVar('Title'),
            'StartDate' => $this->request->getVar('StartDate'),
            'EndDate' => $this->request->getVar('EndDate'),
            'ThemeID' => $this->request->getVar('ThemeID'),
            'TypeID' => $this->request->getVar('TypeID')
        ];

        $form->loadDataFrom($data);

        return $form;
    }

}
