<?php
class HomePage extends Page {

    /**
     * List of database fields. {@link DataObject::$db}
     *
     * @var array
     */
    private static $db = array(
        'LinkedPageDescription' => 'Varchar(128)',
        'ButtonLinkedPageDescription' => 'Varchar(128)'
    );

    /**
     * List of one-to-one relationships. {@link DataObject::$has_one}
     *
     * @var array
     */
    private static $has_one = array(
        'LinkedPage' => 'Page',
        'ButtonLinkedPage' => 'Page',
        'HeroImage' => 'Image'
    );

    /**
     * Returns a FieldList with which to create the main editing form. {@link DataObject::getCMSFields()}
     *
     * @return FieldList The fields to be displayed in the CMS.
     */
    public function getCMSFields()
    {
        $fields = parent::getCMSFields();

        $fields->addFieldsToTab('Root.Image', array(
            UploadField::create('HeroImage', 'Background Image')
                ->setDescription('Use an image that is approximately to the scale of 1200px x 400px')
        ));

        $fields->addFieldsToTab('Root.LinkedPage', array(
            TextField::create('ButtonLinkedPageDescription', 'Button Description'),
            TreeDropdownField::create('ButtonLinkedPageID', "Button Linked Page", "SiteTree"),
            TextField::create('LinkedPageDescription', 'Linked Page Description'),
            TreeDropdownField::create('LinkedPageID', "Linked Page", "SiteTree")
        ));

        return $fields;
    }

}
class HomePage_Controller extends Page_Controller {

    /**
     * An array of actions that can be accessed via a request. Each array element should be an action name, and the
     * permissions or conditions required to allow the user to access it.
     *
     * <code>
     * array (
     *     'action', // anyone can access this action
     *     'action' => true, // same as above
     *     'action' => 'ADMIN', // you must have ADMIN permissions to access this action
     *     'action' => '->checkAction' // you can only access this action if $this->checkAction() returns true
     * );
     * </code>
     *
     * @var array
     */
    private static $allowed_actions = array (
    );

    public function init() {
        parent::init();
        // You can include any CSS or JS required by your project here.
        // See: http://doc.silverstripe.org/framework/en/reference/requirements
    }

    public function UpcomingEvents()
    {
        $where = '"StartDate" >= CURDATE()';
        $children = EventPage::get()
            ->where($where)
            ->limit(3)
            ->sort('StartDate', 'ASC');

        return $children;
    }

    public function EventListPage()
    {
        return EventListPage::get()->first();
    }

    public function ChurchSearchPage()
    {
        return ChurchSearchPage::get()->first();
    }

    public function MinisterSearchPage()
    {
        return MinisterSearchPage::get()->first();
    }
}
