<?php

/**
 * BlogDefaultsExtension.
 *
 * @author       Tom Densham <tom.densham@studiobonito.co.uk>
 * @copyright    Studio Bonito Ltd.
 */
class BlogDefaultsExtension extends DataExtension
{
    static $defaults = array (
        'ShowInMenus' => false
    );

    /**
     * List of one-to-many relationships. {@link DataObject::$has_many}
     *
     * @var array
     */
    static $has_one = array(
        'Type' => 'Type',
        'Theme' => 'Theme'
    );

    public function updateCMSFields(FieldList $fields)
    {
        $fields->removeFieldFromTab('Root.Main', 'Author');

        $typeDropdownField = $this->createDropdownField('Type');
        $themeDropdownField = $this->createDropdownField('Theme');

        $fields->addFieldsToTab(
            'Root.Taxonomy',
            array(
                $typeDropdownField,
                $themeDropdownField
            )
        );
    }

    /**
     * Creates a DropdownField given a field name and object class.
     *
     * @param      $name
     * @param null $className
     *
     * @return DropdownField
     * @throws BadFunctionCallException
     */
    protected function createDropdownField($name, $className = null)
    {
        if (is_null($className)) {
            if (class_exists($name)) {
                $className = $name;
            } else {
                throw new BadFunctionCallException('Either $className must be provided or $name must be a valid class.');
            }
        }

        $source = function () use ($className) {
            return $className::get()->map('ID', 'Title');
        };

        $dropdownField = DropdownField::create(
            $name."ID",
            $name,
            $source()
        );
        $dropdownField->useAddNew($className, $source)
            ->setEmptyString('(Select one '.$name.')');

        return $dropdownField;


    }
}