<?php

class JobPage extends Page
{
    /**
     * Human-readable singular name. See {@link DataObject::$singular_name}
     * @var string
     */
    public static $singular_name = 'Job Page';

    /**
     * Human-readable pluaral name. See {@link DataObject::$plural_name}
     * @var string
     */
    public static $plural_name = 'Job Pages';

    /**
     * Human-readable description of Page. See {@link DataObject::$description}
     *
     * @access public
     * @static
     * @var string
     */
    public static $description = 'Job page';

    // public static $icon = 'articles/images/article-page.png';

    // public static $allowed_children = array(
    //     'ArticlePage',
    // );

    /**
     * List of database fields. {@link DataObject::$db}
     *
     * @access public
     * @static
     * @var array
     */
    public static $db = array(
        'ClosingDate'  => 'Date',
        'Location' => 'Varchar(128)',
        'Summary'   => 'Text',
    );

    /**
     * Returns a FieldList with which to create the editing form. {@link SiteTree::getCMSFields()}
     *
     * @return FieldList
     */
    public function getCMSFields()
    {
        $fields = parent::getCMSFields();

        $dateField = new DateField('ClosingDate', _t('JOB.ClosingDateTitle', 'Closing Date'));
        $dateField->setConfig('showcalendar', true);
        $fields->addFieldToTab('Root.Main', $dateField);

        $fields->addFieldToTab('Root.Main', new TextField('Location', _t('JOB.LocationTitle', 'Location')));
        $fields->addFieldToTab('Root.Main', new TextAreaField('Summary', _t('JOB.SummaryTitle', 'Summary')));

        return $fields;
    }
}

class JobPage_Controller extends Page_Controller
{

}
