<?php

use StudioBonito\SilverStripe\Inuit\Forms\InuitForm;

/**
 * EventSearchForm.
 *
 * @author       Tom Densham <tom.densham@studiobonito.co.uk>
 * @copyright    Studio Bonito Ltd.
 */
class EventSearchForm extends InuitForm
{
    /**
     * Create a new form, with the given fields and action buttons.
     * Fallback to default fields and action buttons if none are supplied.
     *
     * @param Controller $controller
     * @param String     $name
     * @param FieldList  $fields
     * @param FieldList  $actions
     * @param Validator  $validator
     */
    public function __construct($controller, $name, FieldList $fields = null, FieldList $actions = null, $validator = null)
    {
        if (!$fields || !$fields instanceof FieldList) {
            $fields = $this->getDefaultFields();
        }
        if (!$actions || !$actions instanceof FieldList) {
            $actions = $this->getDefaultActions();
        }
        if (!$validator || !$validator instanceof Validator) {
            $validator = $this->getDefaultValidator();
        }

        parent::__construct($controller, $name, $fields, $actions, $validator);
    }

    /**
     * Create the default fields.
     *
     * @return FieldList
     */
    public function getDefaultFields()
    {
        $fields = FieldList::create();

        $fields->push( TextField::create('Title', _t('EVENTSEARCH.Title', 'Event Title'))
                           ->setFieldHolderClass('one-half  palm-one-whole  push-half--bottom')
                           ->addExtraClass('form-control'));

        $dropdownField = DropdownField::create(
            "ThemeID",
            'Theme',
            Theme::get()->map('ID', 'Title')
        );
        $dropdownField->setEmptyString('Select a theme')
            ->setFieldHolderClass('one-half  palm-one-whole  push-half--bottom')
            ->addExtraClass('form-control');

        $fields->push($dropdownField);

        $startDate = DateField::create('StartDate', _t('EVENTSEARCH.StartDate', 'Start Date'))
            ->setConfig('showcalendar',true)
            ->setFieldHolderClass('one-quarter  palm-one-half  push-half--bottom  fieldholder-small')
            ->addExtraClass('form-control');
        $fields->push($startDate);

        $endDate = DateField::create('EndDate', _t('EVENTSEARCH.EndDate', 'End Date'))
            ->setConfig('showcalendar',true)
            ->setFieldHolderClass('one-quarter  palm-one-half  push-half--bottom  fieldholder-small')
            ->addExtraClass('form-control');
        $fields->push($endDate);

        $typeDropdownField = DropdownField::create(
            "TypeID",
            'Type',
            Type::get()->map('ID', 'Title')
        );
        $typeDropdownField->setEmptyString('Select a type')
            ->setFieldHolderClass('one-half  palm-one-whole  push-half--bottom')
            ->addExtraClass('form-control');
        $fields->push($typeDropdownField);

        return $fields;
    }

    /**
     * Create the default actions.
     *
     * @return FieldList
     */
    public function getDefaultActions()
    {
        $actions = FieldList::create();

        $searchAction = new FormAction('search', 'Search');
        $searchAction
            ->setUseButtonTag(true)
            ->addExtraClass('btn  push-half--top');
        $actions->push($searchAction);

        return $actions;

        return $actions;
    }

    /**
     * Create the default validator.
     *
     * @return Validator
     */
    public function getDefaultValidator()
    {
        return null; // TODO: Create and configure Validator (suggest sheadawson/silverstripe-zenvalidator)
    }

    public function search(array $data, Form $form)
    {
        $vars = array();
        $skip = array(
            'action_search',
            'SecurityID',
            'url' 
        );
        foreach($data as $key => $value)
        {
            if(!in_array($key, $skip) AND $value)
            {
                $vars[] = $key.'='.$value;
            }
        }

        $url = $this->controller->Link();
        return $this->controller->redirect( rtrim($url, '/') . "?" . implode('&', $vars));
    }
}