<!doctype html>
<!--[if IE 8]>         <html class="no-js ie8" lang="en"> <![endif]-->
<!--[if gt IE 8]><!--> <html class="no-js" lang="en"> <!--<![endif]-->
<head>
    <meta charset="UTF-8">
    <title>{$SiteConfig.Title} &dash; {$MenuTitle}</title>
    <% base_tag %>
    <meta name=viewport content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=0">
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />

    <script src="//use.typekit.net/eay6vxh.js"></script>
    <script>try{Typekit.load();}catch(e){}</script>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/html5shiv/3.7.2/html5shiv-printshiv.min.js"></script>

    <link rel="stylesheet" href="/site/css/styles.css"/>
</head>
<body class="nav-on-left">

    <div id="container" class="container cd-main-content">
        <% include Header %>
        $Layout
        <div class="footer">
            <div class="wrapper">
            <div class="layout">
                <div class="layout__item one-half palm-one-whole">
                    <address>
                        <% if $SiteConfig.AddressLine1 %>{$SiteConfig.AddressLine1},<% end_if %>
                        <% if $SiteConfig.AddressLine2 %>{$SiteConfig.AddressLine2},<% end_if %>
                        <% if $SiteConfig.AddressLine3 %>{$SiteConfig.AddressLine3},<% end_if %> <br/>
                        <% if $SiteConfig.City %>{$SiteConfig.City},<% end_if %>
                        <% if $SiteConfig.County %>{$SiteConfig.County},<% end_if %>
                        <% if $SiteConfig.PostCode %>{$SiteConfig.PostCode}.<% end_if %>
                    </address>
                </div><!--
            ---><div class="layout__item one-half palm-one-whole">
                    <p class="float--right text--right palm-text--left">
                        <% if $SiteConfig.PrivacyLink %>
                        <a href="$SiteConfig.PrivacyLink.Link">Privacy Policy</a>
                        <% end_if %>
                        | <a href="https://districthub.co.uk/">Powered by District Hub</a> <br/>
                        <a href="http://studiobonito.co.uk/" class="credits__link">Website built by <span class="credits__target">Studio Bonito</span></a>
                    </p>
                </div>
            </div>
            </div>
        </div>
    </div>

    <div class="cd-overlay"></div>

    <nav class="cd-nav">
        <ul id="cd-primary-nav" class="cd-primary-nav is-fixed ">
            <li class="visuallyhidden--lap-and-up"><a href="{$SiteConfig.SearchAPIURL}/auth/login">Login</a></li>
            <% loop $Menu(1) %>
                <li<% if $Children %> class="has-children"<% end_if %>>
                    <a href="$Link">$MenuTitle</a>
                <% if $Children %>
                    <ul class="cd-secondary-nav is-hidden">
                        <li class="go-back"><a href="#0">Back</a></li>
                        <li class="see-all"><a href="$Link">$MenuTitle</a></li>
                        <% loop $Children %>
                            <li<% if $Children %> class="has-children"<% end_if %>>
                                <a href="$Link">$MenuTitle</a>
                                <% if $Children %>
                                    <ul class="is-hidden">
                                        <li class="go-back"><a href="#0">Back</a></li>
                                        <li class="see-all"><a href="$Link">$MenuTitle</a></li>
                                        <% loop $Children %>
                                            <li><a href="$Link">$MenuTitle</a></li>
                                        <% end_loop %>
                                    </ul>
                                <% end_if %>
                            </li>
                        <% end_loop %>
                    </ul>
                <% end_if %>
                </li>
            <% end_loop %>
        </ul>
    </nav>

<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/1.11.2/jquery.min.js"></script>
<script>window.jQuery || document.write('<scr'+'ipt src="/vendor/jquery/dist/jquery.min.js"><\/scr'+'ipt>')</script>
<script src="/site/javascript/vendor.js"></script>
<script src="/site/javascript/scripts.js"></script>
</body>
</html>