<?php
class MinisterSearchPage extends Page {

    private static $db = array(

    );

    private static $has_one = array(
    );

    /**
     * Returns a FieldList with which to create the editing form. {@link SiteTree::getCMSFields()}
     *
     * @return FieldList
     */
    public function getCMSFields()
    {
        $fields = parent::getCMSFields();



        return $fields;
    }
}
class MinisterSearchPage_Controller extends Page_Controller {

    /**
     * An array of actions that can be accessed via a request. Each array element should be an action name, and the
     * permissions or conditions required to allow the user to access it.
     *
     * <code>
     * array (
     *     'action', // anyone can access this action
     *     'action' => true, // same as above
     *     'action' => 'ADMIN', // you must have ADMIN permissions to access this action
     *     'action' => '->checkAction' // you can only access this action if $this->checkAction() returns true
     * );
     * </code>
     *
     * @var array
     */
    private static $allowed_actions = array (
        'MinisterSearchForm',
        'ContactForm'
    );

    /**
     * The ID for the circuit to filter by.
     *
     * @config
     */
    private static $circuitID = null;

    public function init() {
        parent::init();
        // You can include any CSS or JS required by your project here.
        // See: http://doc.silverstripe.org/framework/en/reference/requirements
    }

    public function MinisterSearchForm()
    {
        $form = new MinisterSearch($this, 'MinisterSearchForm');

        $data = [
            'Name' => $this->request->getVar('name'),
            'Location' => $this->request->getVar('location'),
            'Distance' => $this->request->getVar('distance'),
            'Church' => $this->request->getVar('church')
        ];

        $form->loadDataFrom($data);

        $actions = $form->Actions();

        $button = $actions->pop();
        $actions->push(LiteralField::create('AllMinisters', '<a href="'.$this->Link().'" class="push-half--right small">See all ministers</a>'));
        $actions->push($button);

        $form->setActions($actions);

        return $form;
    }

    public function SearchResults()
    {
        $vars = array();

        if($this->request->getVar('name'))
        {
            $vars[] = 'name=' . $this->request->getVar('name');
        }

        if($this->request->getVar('location'))
        {
            $vars[] = 'location=' . $this->request->getVar('location');
        }

        if($this->request->getVar('church'))
        {
            $vars[] = 'church=' . $this->request->getVar('church');
        }

        if($this->request->getVar('distance') && $this->request->getVar('distance') != '-')
        {
            $vars[] = 'distance=' . $this->request->getVar('distance');
        }

        if($this->config()->circuitID)
        {
            $vars[] = 'circuit_id='.$this->config()->circuitID;
        }

        $config = SiteConfig::current_site_config();

        $service = new RestfulService($config->SearchApiUrl);
        $response = $service->request('/api/v1/ministers?'. implode('&', $vars));

        $json = Convert::json2array($response->getBody());

        if($json['data'])
        {
            $churches = new ArrayList($json['data']);
        } else {
            $churches = new ArrayList(array());
        }

        $list = new PaginatedList($churches, $this->request);
        $list->setPageLength(15);
        return $list;
    }

    public function IsLocationSearch()
    {
        if($this->request->getVar('location') && $this->request->getVar('distance'))
        {
            return true;
        }
        return false;
    }

    public function ContactForm()
    {
        return new ContactForm($this, 'ContactForm');
    }
}
