Feature: View Articles

  Background:
    Given a "article list page" "Article List"
    And a "article page" "Article One" has the following data
      | Summary     | This is an article page 1                |
      | Content     | This is the content for the article page |
    And a "article page" "Article Two" has the following data
      | Summary     | This is an article page 2                |
      | Content     | This is the content for the article page |
    And a "article page" "Article Three" has the following data
      | Summary     | This is an article page  3               |
      | Content     | This is the content for the article page |
    And the "article page" "Article One" is a child of a "article list page" "Article List"
    And the "article page" "Article One" is published
    And the "article page" "Article Two" is a child of a "article list page" "Article List"
    And the "article page" "Article Two" is published
    And the "article page" "Article Three" is a child of a "article list page" "Article List"
    And the "article page" "Article Three" is published
    And I go to "/dev/build?flush=all"

  # Test that article page lists children
  Scenario:
    Given I go to the "article list page" "Article List"
    Then I should see a ".article-list" element
    Then I should see 3 ".article" elements
    Then I should see "Article One" in the ".article:nth-child(1) .article__title" element

  # Test that article page shows correct content
  Scenario:
    Given I go to the "article page" "Article One"
    Then I should see "Article One" in the ".article__title" element
    Then I should see "This is an article page" in the ".article__summary" element
    Then I should see "This is the content for the article page" in the ".article__content" element

  # Test that article page lists sibling navigation
  Scenario:
    Given I go to the "article page" "Article One"
    Then I should see a ".sibling-list" element
    Then I should see 2 ".sibling" elements
    Then I should see "Article Two" in the ".sibling:nth-child(3) .sibling__title" element
    When I follow "Go to 'Article Two'"
    Then I should be on "/article-list/article-two/"

  # Test that article page back button works
  Scenario:
    Given I go to the "article page" "Article One"
    When I follow "Go to 'Article List'"
    Then I should be on "/article-list/"