Feature: Find And Contact Minister

  Background:
    Given a "minister" "Bob Doe" has the following data
      | Church    | Acocks Green Methodist Church |
      | Telephone | 0123456789                    |
      | PostCode  | B27 7YE                       |
    And a "minister" "John Smith" has the following data
      | Church    | Selly Oak Methodist Church |
      | Telephone | 9876543210                 |
      | PostCode  | B29 6HT                    |
    And a "minister" "Frank Michaels" has the following data
      | Church    | Solihull Methodist Church |
      | Telephone | 1122334455               |
      | PostCode  | B91 1LG                  |
    And a "minister" "Frank OConnol" has the following data
      | Church    | Shirley Methodist Church |
      | Telephone | 6677889900               |
      | PostCode  | B90 3AL                  |
    And a "minister search page" "Contact a minister" with "Ministers"="=>Minister.Bob Doe,=>Minister.John Smith,=>Minister.Frank Michaels,=>Minister.Frank OConnol"

  # Search for one church
  Scenario:
    Given I go to the "minister search page" "Minister Search"
    When I fill in "church" with "Acocks Green"
    And press "Search"
    Then I should see 1 ".minister" elements
    And I should see "Bob Doe" in the ".minister:nth-child(1) .minister__name" element
    And I should see "Acocks Green Methodist Church" in the ".minister:nth-child(1) .minister__church" element
    And I should see "0123456789" in the ".minister:nth-child(1) .minister__telephone" element

  # Search for one exact name
  Scenario:
    Given I go to the "minister search page" "Minister Search"
    When I fill in "name" with "John Smith"
    And press "Search"
    Then I should see 1 ".minister" elements
    And I should see "John Smith" in the ".minister:nth-child(1) .minister__name" element
    And I should see "Birmingham Methodist Church" in the ".minister:nth-child(1) .minister__church" element
    And I should see "9876543210" in the ".minister:nth-child(1) .minister__telephone" element

  # Search for one exact location
  Scenario:
    Given I go to the "minister search page" "Minister Search"
    When I fill in "location" with "B91 1LG"
    And press "Search"
    Then I should see 1 ".minister" elements
    And I should see "Frank Michaels" in the ".minister:nth-child(1) .minister__name" element
    And I should see "Solihull Methodist Church" in the ".minister:nth-child(1) .minister__church" element
    And I should see "1122334455" in the ".minister:nth-child(1) .minister__telephone" element