<?php

class HomePage extends Page
{

    /**
     * List of database fields. {@link DataObject::$db}
     *
     * @var array
     */
    private static $db = [
        'LinkedPageDescription'       => 'Varchar(128)',
        'ButtonLinkedPageDescription' => 'Varchar(128)',
    ];

    /**
     * List of one-to-one relationships. {@link DataObject::$has_one}
     *
     * @var array
     */
    private static $has_one = [
        'LinkedPage'       => 'Page',
        'ButtonLinkedPage' => 'Page',
        'HeroImage'        => 'Image',
    ];

    /**
     * Returns a FieldList with which to create the main editing form. {@link DataObject::getCMSFields()}
     *
     * @return FieldList The fields to be displayed in the CMS.
     */
    public function getCMSFields()
    {
        $fields = parent::getCMSFields();

        $fields->addFieldsToTab(
            'Root.Image',
            [
                UploadField::create('HeroImage', 'Background Image')
                    ->setDescription('Use an image that is approximately to the scale of 1200px x 400px'),
            ]
        );

        $fields->addFieldsToTab(
            'Root.LinkedPage',
            [
                TextField::create('ButtonLinkedPageDescription', 'Button Description'),
                TreeDropdownField::create('ButtonLinkedPageID', "Button Linked Page", "SiteTree"),
                TextField::create('LinkedPageDescription', 'Linked Page Description'),
                TreeDropdownField::create('LinkedPageID', "Linked Page", "SiteTree"),
            ]
        );

        return $fields;
    }

}

class HomePage_Controller extends Page_Controller
{

    /**
     * An array of actions that can be accessed via a request. Each array element should be an action name, and the
     * permissions or conditions required to allow the user to access it.
     *
     * <code>
     * array (
     *     'action', // anyone can access this action
     *     'action' => true, // same as above
     *     'action' => 'ADMIN', // you must have ADMIN permissions to access this action
     *     'action' => '->checkAction' // you can only access this action if $this->checkAction() returns true
     * );
     * </code>
     *
     * @var array
     */
    private static $allowed_actions = [
    ];

    public function init()
    {
        parent::init();
        // You can include any CSS or JS required by your project here.
        // See: http://doc.silverstripe.org/framework/en/reference/requirements
    }

    public function UpcomingEvents()
    {
        // Set the limit of events to be shown
        $limit = 3;
        // Get all the promoted events
        $events = EventPage::get()
            ->filter('PromotedEvent', 1)
            ->sort('StartDate', 'ASC')
            ->limit($limit);
        // Count the events to see how many we have
        $count = $events->count();
        //Create New array list
        $eventsArray = new ArrayList($events->toArray());

        // If there are less promoted events than the limit...
        if ($count < $limit) {
            // ...Create a new limit
            $countLimit = $limit - $count;
            // Set up where for recent events
            $where = '"StartDate" >= CURDATE()';
            // Get upcoming events
            $children = EventPage::get()
                ->where($where)
                ->limit($countLimit)
                ->sort('StartDate', 'ASC');
            // Merge the two lists together
            $eventsArray->merge($children->toArray());
        }

        return $eventsArray;
    }

    public function EventListPage()
    {
        return EventListPage::get()->first();
    }

    public function ChurchSearchPage()
    {
        return ChurchSearchPage::get()->first();
    }

    public function MinisterSearchPage()
    {
        return MinisterSearchPage::get()->first();
    }
}
