<?php

class Type extends DataObject
{
    /**
     * List of database fields. {@link DataObject::$db}
     *
     * @var array
     */
    private static $db = array(
        'Title'  => 'Varchar(255)',
        'Sort'   => 'Int'
    );

    /**
     * List of one-to-one relationships. {@link DataObject::$has_one}
     *
     * @var array
     */
    private static $has_one = array(
        'Page' => 'Page'
    );
    /**
     * Returns a FieldList with which to create the main editing form. {@link DataObject::getCMSFields()}
     *
     * @return FieldList The fields to be displayed in the CMS.
     */
    public function getAddNewFields()
    {
        $fields = FieldList::create();

        $fields->push(HeaderField::create('AddNewType'));

        $fields->push(TextField::create('Title'));

        return $fields;
    }
}