<div class="wrapper">
    <h1>$Title</h1>

    <div class="typography">$Content</div>

    <% with $ContactForm %>
        <% include StatusMessage %>
    <% end_with %>

    <section class="event-form panel panel-default">
        <div class="panel-heading">Search for a minister</div>
        <div class="panel-body">
            $MinisterSearchForm
        </div>
    </section>

    <% if $SiteConfig.SearchApiUrl %>
        <% if $SearchResults %>
        <p class="visuallyhidden--lap-and-up small"><i>Scroll the table left and right to see more infomation.</i></p>
        <div class="table-responsive">
            <table class="table table table-striped table-bordered table-hover">
                <colgroup>
                    <col class="">
                    <col class="">
                    <% if $IsLocationSearch %>
                    <col class="">
                    <% end_if %>
                    <col class="one-sixth">
                </colgroup>
                <thead>
                    <tr>
                        <th>Name</th>
                        <th>Church</th>
                        <th>Phone</th>
                        <% if $IsLocationSearch %>
                        <th>Distance</th>
                        <% end_if %>
                        <th>Contact</th>
                    </tr>
                </thead>
                <tbody>
                <% loop $SearchResults %>
                    <tr class="row">
                        <td>$name</td>
                        <td>$church</td>
                        <td>$phone_number</td>
                        <% if $Top.IsLocationSearch %>
                        <td>$distance miles</td>
                        <% end_if %>
                        <td class="text--center">
                            <% if $email_address %>
                                <a class="btn  open-popup-link" data-effect="mfp-zoom-in" data-mfp-src="#contact-form"  data-minister-name="{$name}" href="/contact?MinisterName={$name}" title="Contact $name">Get in
                                    contact</a>
                            <% end_if %>
                        </td>
                    </tr>
                <% end_loop %>
                </tbody>
            </table>
        </div>

            <% if $SearchResults.MoreThanOnePage %>
                <ul class="pagination">
                    <% loop $SearchResults.Pages %>
                        <% if $CurrentBool %>
                            <li class="pagination__current"><a href="/$Link">$PageNum</a></li>
                        <% else %>
                            <% if $Link %>
                                <li><a href="/$Link">$PageNum</a></li>
                            <% else %>
                                ...
                            <% end_if %>
                        <% end_if %>
                    <% end_loop %>
                </ul>
            <% end_if %>
        <% else %>

            <p>There was no results for your search.</p>

        <% end_if %>
    <% else %>
        <p>This section has not been set up correctly. Please contact the website administrator.</p>
    <% end_if %></div>

<div id="contact-form" class="modal mfp-hide mfp-with-anim">
    <h2>Fill in the form to get in contact</h2>
    $ContactForm
</div>
