<?php

class EventListPage extends Page
{
    /**
     * Human-readable singular name. See {@link DataObject::$singular_name}
     * @var string
     */
    public static $singular_name = 'Event List page';

    /**
     * Human-readable pluaral name. See {@link DataObject::$plural_name}
     * @var string
     */
    public static $plural_name = 'Event Page Lists';

    /**
     * Human-readable description of Page. See {@link DataObject::$description}
     *
     * @access public
     * @static
     * @var string
     */
    public static $description = 'List of Event pages';

    //public static $icon = 'articles/images/article-holder.png';

     public static $allowed_children = array(
         'EventPage'
     );

    /**
     * List of database fields. {@link DataObject::$db}
     *
     * @var array
     */
    public static $db = array(
        'PageLength' => 'Int'
    );


    public static $defaults = array(
        'PageLength' => 10
    );

    /**
     * Returns a FieldList with which to create the editing form. {@link SiteTree::getCMSFields()}
     *
     * @return FieldList
     */
    public function getCMSFields()
    {
        $fields = parent::getCMSFields();

        return $fields;
    }

    public function getSettingsFields()
    {
        $fields = parent::getSettingsFields();
        $pageLengthNumericField = new NumericField('PageLength', 'Page length');
        $pageLengthNumericField->setDescription('Number of child pages to display per page.');
        $fields->addFieldToTab('Root.Settings', $pageLengthNumericField);
        return $fields;
    }
}

class EventListPage_Controller extends Page_Controller
{

    protected $order = 'ASC';
    protected $startDate = null;
    protected $endDate = null;
    protected $textSearch = null;
    protected $dateComparison = '>=';

    public function init() {
        parent::init();
    }

    private static $allowed_actions = array (
        'archive',
        'EventSearchForm'
    );

    public function Children()
    {
        if(((int)$this->PageLength) > 0) {
            $children = SiteTree::get()->filter(array('ParentID' => $this->ID));
            $childrenPaginatedList = new PaginatedList($children, $this->request);
            $childrenPaginatedList->setPageLength($this->PageLength);
            return $childrenPaginatedList;
        }
        return parent::Children();
    }

    public function Events()
    {
        if ($this->request->param('Action') === 'archive') {
            $this->order = "DESC";
            $this->dateComparison = "<=";
        }

        $filter = array( 'ParentID' => $this->ID);
        $where = '"EndDate" '.$this->dateComparison.' CURDATE()';

        if ($title = $this->request->getVar('Title')) {
            $filter['Title:PartialMatch'] = $title;
        }

        if ($themeID = $this->request->getVar('ThemeID')) {
            $filter['ThemeID'] = $themeID;
        }

        if ($typeID = $this->request->getVar('TypeID')) {
            $filter['TypeID'] = $typeID;
        }

        // Get all query string variables
        $vars = $this->request->getVars();

        // Set start and end time if provided in query string
        $startDate = isset($vars['StartDate']) ? DateTime::createFromFormat('d M Y', $vars['StartDate']) : false;
        $endDate = isset($vars['EndDate']) ? DateTime::createFromFormat('d M Y', $vars['EndDate']) : false;

        if ($startDate && $endDate) {
            $where = sprintf(
                "DATE(EndDate) BETWEEN '%s' AND '%s'",
                $startDate->format('Y-m-d'),
                $endDate->format('Y-m-d')
            );
        } else {
            if ($startDate) {
                $where = sprintf("DATE(StartDate) >= '%s'", $startDate->format('Y-m-d'));
            }

            if ($endDate) {
                $where = sprintf("DATE(EndDate) <= '%s'", $endDate->format('Y-m-d'));
            }
        }

        $children = EventPage::get()
            ->where($where)
            ->filter($filter)
            ->sort('StartDate', $this->order);

        // Display a paginated list if the page length is greater than 0
        if ($this->PageLength > 0) {
            $childrenPaginatedList = new PaginatedList($children, $this->request);
            $childrenPaginatedList->setPageLength($this->PageLength);

            return $childrenPaginatedList;
        }

        return $children;
    }

    public function EventSearchForm()
    {
        $form = new EventSearchForm($this, 'EventSearchForm');

        $data = [
            'Title' => $this->request->getVar('Title'),
            'StartDate' => $this->request->getVar('StartDate'),
            'EndDate' => $this->request->getVar('EndDate'),
            'ThemeID' => $this->request->getVar('ThemeID'),
            'TypeID' => $this->request->getVar('TypeID')
        ];

        $form->loadDataFrom($data);

        return $form;
    }

}
