<?php

/**
 * SiteConfigStyleExtension adds options to the Site config for site wide styles.
 *
 * @author Steve Heyes <steve.heyes@studiobonito.co.uk>
 * @copyright (c) 2013, Studio Bonito Ltd.
 * @version 1.0
 */
class SiteConfigStyleExtension extends DataExtension {

    /**
     * List of database fields. {@link DataObject::$db}
     *
     * @var array
     */
    private static $db = array(
        'SearchApiUrl' => 'Varchar(2083)',
        'AddressLine1' => 'Varchar(255)',
        'AddressLine2' => 'Varchar(255)',
        'AddressLine3' => 'Varchar(255)',
        'City' => 'Varchar(255)',
        'County' => 'Varchar(255)',
        'PostCode' => 'Varchar(10)',
    );

    /**
     * List of one-to-one relationships. {@link DataObject::$has_one}
     *
     * @var array
     */
    private static $has_one = array(
        'PrivacyLink' => 'SiteTree'
    );

    /**
     * This function is used to provide modifications to the form in the CMS
     * by the extension.
     *
     * @param FieldList $fields FieldList with a contained TabSet
     */
    public function updateCMSFields(FieldList $fields)
    {
        $fields->addFieldToTab(
            'Root.SearchApiUrl',
            TextField::create('SearchApiUrl', _t('SearchApiUrl.URL', 'Search API URL'))
        );

        $fields->addFieldsToTab(
            'Root.Address',
            array(
                TextField::create('AddressLine1', _t('Address.ADDRESSLINE1', 'Address Line 1')),
                TextField::create('AddressLine2', _t('Address.ADDRESSLINE2', 'Address Line 2')),
                TextField::create('AddressLine3', _t('Address.ADDRESSLINE3', 'Address Line 3')),
                TextField::create('City', _t('Address.CITY', 'City')),
                TextField::create('County', _t('Address.COUNTY', 'County')),
                TextField::create('PostCode', _t('Address.POSTCODE', 'Post Code')),
            )
        );

        $fields->addFieldToTab(
            'Root.Links',
            TreeDropdownField::create('PrivacyLinkID', _t('PrivacyLink.DROPDOWN', 'Privacy Policy Link'), 'SiteTree')
        );
    }
}