'use strict';

// IIFE - Immediately Invoked Function Expression
(function(yourcode) {

    // The global jQuery object is passed as a parameter
    yourcode(window.jQuery, window, document);

}(function($, window, document) {

    // The $ is now locally scoped
    $(function() {
        moveNavigation();
        $(window).on('resize', function(){
            (!window.requestAnimationFrame) ? setTimeout(moveNavigation, 300) : window.requestAnimationFrame(moveNavigation);
        });

        //mobile - open lateral menu clicking on the menu icon
        $('#menu-button').on('click', function(event){
            event.preventDefault();

            if( $('#container').hasClass('nav-is-visible')) {
                closeNav();
                $('.cd-overlay').removeClass('is-visible');
            } else {
                $(this).addClass('nav-is-visible');
                $('.cd-primary-nav').addClass('nav-is-visible');
                $('#container').addClass('nav-is-visible').one('webkitTransitionEnd otransitionend oTransitionEnd msTransitionEnd transitionend', function(){
                    $('body').addClass('overflow-hidden');
                });
                $('.cd-overlay').addClass('is-visible');
            }
        });


        //close lateral menu on mobile
        $('.cd-overlay').on('swiperight', function(){
            if($('.cd-primary-nav').hasClass('nav-is-visible')) {
                closeNav();
                $('.cd-overlay').removeClass('is-visible');
            }
        });
        $('.nav-on-left .cd-overlay').on('swipeleft', function(){
            if($('.cd-primary-nav').hasClass('nav-is-visible')) {
                closeNav();
                $('.cd-overlay').removeClass('is-visible');
            }
        });
        $('.cd-overlay').on('click', function(){
            closeNav();
            $('.cd-overlay').removeClass('is-visible');
        });


        //prevent default clicking on direct children of .cd-primary-nav
        $('.cd-primary-nav').children('.has-children').children('a').on('click', function(event){
            event.preventDefault();
        });
        //open submenu
        $('.has-children').children('a').on('click', function(event){
            var selected = $(this);
            if($('html').hasClass('ie8'))
            {
                window.location(selected.attr('href'));
                return;
            }
            event.preventDefault();
            if( selected.next('ul').hasClass('is-hidden') ) {
                selected.addClass('selected').next('ul').removeClass('is-hidden').end().parent('.has-children').parent('ul').addClass('moves-out');
                selected.parent('.has-children').siblings('.has-children').children('ul').addClass('is-hidden').end().children('a').removeClass('selected');
                $('.cd-overlay').addClass('is-visible');
            } else {
                selected.removeClass('selected').next('ul').addClass('is-hidden').end().parent('.has-children').parent('ul').removeClass('moves-out');
                $('.cd-overlay').removeClass('is-visible');
            }
        });

        //submenu items - go back link
        $('.go-back').on('click', function(){
            $(this).parent('ul').addClass('is-hidden').parent('.has-children').parent('ul').removeClass('moves-out');
        });

        function closeNav() {
            $('#menu-button').removeClass('nav-is-visible');
            $('.cd-primary-nav').removeClass('nav-is-visible');
            $('.has-children ul').addClass('is-hidden');
            $('.has-children a').removeClass('selected');
            $('.moves-out').removeClass('moves-out');
            $('#container').removeClass('nav-is-visible').one('webkitTransitionEnd otransitionend oTransitionEnd msTransitionEnd transitionend', function(){
                $('body').removeClass('overflow-hidden');
            });
        }

        function moveNavigation(){
            var navigation = $('.cd-nav');
            navigation.detach();
            navigation.insertAfter('#container');
        }
    });

    }
));
