Feature: View Jobs

  Background:
    Given a "job holder page" "Job List"
    And a "job page" "Job Single" has the following data
      | ClosingDate | 2015-02-14                       |
      | Location    | Birmingham                       |
      | Summary     | A new job in Birmingham          |
      | Content     | Here is all the info for the job |
    And a "job page" "Job One" has the following data
      | ClosingDate | 2015-02-14                       |
      | Location    | Tokyo                            |
      | Summary     | A new job in Tokyo               |
      | Content     | Here is all the info for the job |
    And a "job page" "Job Two" has the following data
      | ClosingDate | 2015-02-14                                |
      | Location    | Solihull                                  |
      | Summary     | A new job in Solihull                     |
      | Content     | Here is all the info for the Solihull job |
    And a "job page" "Job Three" has the following data
      | ClosingDate | 2015-02-14                                 |
      | Location    | Erdington                                  |
      | Summary     | A new job in Erdington                     |
      | Content     | Here is all the info for the Erdington job |
    And the "job page" "Job One" is a child of a "job holder page" "Job List"
    And the "job page" "Job One" is published
    And the "job page" "Job Two" is a child of a "job holder page" "Job List"
    And the "job page" "Job Two" is published
    And the "job page" "Job Three" is a child of a "job holder page" "Job List"
    And the "job page" "Job Three" is published
    And I go to "/dev/build?flush=all"

  Scenario: Viewing Job List Page
    Given I go to the "job holder page" "Job List"
    Then I should see a ".job-list" element
    Then I should see 3 ".job-list__job" elements
    Then I should see "Job One" in the ".job-list__job:nth-child(1) .job-list__title" element
    Then I should see "2015-02-14" in the ".job-list__job:nth-child(1) .job-list__date" region
    Then I should see "Tokyo" in the ".job-list__job:nth-child(1) .job-list__location" region
    Then I should see "A new job in Tokyo" in the ".job-list__job:nth-child(1) .job-list__summary" region

  Scenario:
    Given I go to the "job holder page" "Job List"
    When I follow "See more information for 'Job One'"
    Then I should be on "/job-list/job-one/"

  Scenario: Viewing Job Page
    Given I go to the "job page" "Job Single"
    Then I should see "Job Single" in the ".job__title" region
    Then I should see "2015-02-14" in the ".job__closing-date" region
    Then I should see "Birmingham" in the ".job__location" region
    Then I should see "A new job in Birmingham" in the ".job__summary" region
    Then I should see "Here is all the info for the job" in the ".job__content" region


