<?php

class ContactPage extends Page
{
    /**
     * Human-readable singular name. See {@link DataObject::$singular_name}
     * @var string
     */
    private static $singular_name = 'Contact Page';

    /**
     * Human-readable pluaral name. See {@link DataObject::$plural_name}
     * @var string
     */
    private static $plural_name = 'Contact Pages';

    /**
     * Human-readable description of Page. See {@link DataObject::$description}
     *
     * @access public
     * @static
     * @var string
     */
    private static $description = 'The use case for this page is to be a fallback for no Javascript when contacting officers and ministers';

    /**
     * List of database fields. {@link DataObject::$db}
     *
     * @access public
     * @static
     * @var array
     */
    private static $db = array(
        'ToEmail' => 'Varchar(256)',
    );


    /**
     * Returns a FieldList with which to create the editing form. {@link SiteTree::getCMSFields()}
     *
     * @return FieldList
     */
    public function getCMSFields()
    {
        $fields = parent::getCMSFields();

        $toEmailField = EmailField::create('ToEmail', _t('ContactPage.TOEMAIL', 'E-mail address'));
        $toEmailField->setDescription(
            _t('ContactPage.TOEMAIL_DESC', 'Address to send contact form to if no Officer or Minister is selected.')
        );

        $fields->insertAfter($toEmailField, 'MenuTitle');

        return $fields;
    }
}

class ContactPage_Controller extends Page_Controller
{
    private static $allowed_actions = array (
        'ContactForm'
    );

    public function ContactForm()
    {
        return new ContactForm($this, 'ContactForm');
    }
}
