<?php

class DistrictOfficersListPage extends Page
{
    /**
     * Human-readable singular name. See {@link DataObject::$singular_name}
     *
     * @var string
     */
    public static $singular_name = 'District Officers Page';

    /**
     * Human-readable pluaral name. See {@link DataObject::$plural_name}
     *
     * @var string
     */
    public static $plural_name = 'District Officers Pages';

    /**
     * Human-readable description of Page. See {@link DataObject::$description}
     *
     * @access public
     * @static
     * @var string
     */
    public static $description = 'District Officers page';

    // public static $icon = 'articles/images/article-page.png';

    // public static $allowed_children = array(
    //   'ArticlePage',
    // );

    /**
     * List of database fields. {@link DataObject::$db}
     *
     * @access public
     * @static
     * @var array
     */
//  public static $db = array(
//      'Name'  => 'Varchar(128)',
//      'PhoneNumber'  => 'Varchar(128)',
//      'EmailAddress'  => 'Varchar(128)',
//      'Biography'   => 'Text',
//  );

//  public static $has_one = array(
//      'Picture' => 'Image',
//  );
//
    /**
     * List of has-to-many relationships. {@link DataObject::$has_many}
     *
     * @access public
     * @static
     * @var array
     */
    public static $has_many = [
        'DistrictOfficers' => 'DistrictOfficer',
    ];


    /**
     * Returns a FieldList with which to create the editing form. {@link SiteTree::getCMSFields()}
     *
     * @return FieldList
     */
    public function getCMSFields()
    {
        $fields = parent::getCMSFields();

        // Force the creation of a Social tab and place it after the Main tab.
        $fields->fieldByName('Root')->insertAfter(new Tab('Officers'), 'Main');

        $gridFieldConfig = GridFieldConfig_RecordEditor::create();
        $gridFieldConfig->addComponent(new GridFieldOrderableRows('Sort'));

        $fields->addFieldsToTab(
            'Root.Officers',
            new GridField(
                'DistrictOfficers',
                'District Officers',
                $this->DistrictOfficers(),
                $gridFieldConfig
            )
        );

        return $fields;
    }
}

class DistrictOfficersListPage_Controller extends Page_Controller
{
    private static $allowed_actions = [
        'ContactForm',
    ];

    public function ContactForm()
    {
        return new ContactForm($this, 'ContactForm');
    }
}
