<?php

use StudioBonito\SilverStripe\Inuit\Forms\InuitForm;

/**
 * ChurchSearch.
 *
 * @author       Tom Densham <tom.densham@studiobonito.co.uk>
 * @copyright    Studio Bonito Ltd.
 */
class MinisterSearch extends InuitForm
{
    /**
     * Create a new form, with the given fields and action buttons.
     * Fallback to default fields and action buttons if none are supplied.
     *
     * @param Controller $controller
     * @param String     $name
     * @param FieldList  $fields
     * @param FieldList  $actions
     * @param Validator  $validator
     */
    public function __construct($controller, $name, FieldList $fields = null, FieldList $actions = null, $validator = null)
    {
        if (!$fields || !$fields instanceof FieldList) {
            $fields = $this->getDefaultFields();
        }
        if (!$actions || !$actions instanceof FieldList) {
            $actions = $this->getDefaultActions();
        }
        if (!$validator || !$validator instanceof Validator) {
            $validator = $this->getDefaultValidator();
        }

        $this->disableSecurityToken();

        parent::__construct($controller, $name, $fields, $actions, $validator);
    }

    /**
     * Create the default fields.
     *
     * @return FieldList
     */
    public function getDefaultFields()
    {
        $fields = FieldList::create();

        $fields->push(
            TextField::create('Church', 'Search by churches:')
                ->setFieldHolderClass('one-half palm-one-whole  push-half--bottom')
                ->addExtraClass('form-control')
        );
        $fields->push(
            TextField::create('Name', 'Search by name:')
                ->setFieldHolderClass('one-half palm-one-whole  push-half--bottom')
                ->addExtraClass('form-control')
        );
        $fields->push(
            TextField::create('Location', 'Search by postcode:')
                ->setFieldHolderClass('one-half palm-one-whole  push-half--bottom')
                ->addExtraClass('form-control')
        );

        $distances = [
            '-' => '-',
            10 => 10,
            25 => 25,
            50 => 50,
            100 => 100,
        ];

        $fields->push(
            DropdownField::create('Distance', 'Search by distance to location:', $distances)
                ->setFieldHolderClass('one-half palm-one-whole  push-half--bottom')
                ->addExtraClass('form-control')
        );

        return $fields;
    }

    /**
     * Create the default actions.
     *
     * @return FieldList
     */
    public function getDefaultActions()
    {
        $actions = FieldList::create();

        $searchAction = new FormAction('search', 'Search');
        $searchAction
            ->setUseButtonTag(true)
            ->addExtraClass('btn');
        $actions->push($searchAction);

        return $actions;
    }

    /**
     * Create the default validator.
     *
     * @return Validator
     */
    public function getDefaultValidator()
    {
        return null; // TODO: Create and configure Validator (suggest sheadawson/silverstripe-zenvalidator)
    }

    public function search(array $data, Form $form)
    {
        $vars = array();
        if($data['Name'])
        {
            $vars[] = 'name=' . $data['Name'];
        }

        if($data['Location'])
        {
            $vars[] = 'location=' . $data['Location'];
        }

        if($data['Distance'])
        {
            $vars[] = 'distance=' . $data['Distance'];
        }

        if($data['Church'])
        {
            $vars[] = 'church=' . $data['Church'];
        }

        $url = $this->controller->Link();
        return $this->controller->redirect( rtrim($url, '/') . "?" . implode('&', $vars));
    }
}