<?php

/**
 * DistrictOfficer.
 *
 * @author       Tom Densham <steve.heyes@studiobonito.co.uk>
 * @copyright    Studio Bonito Ltd.
 */
class DistrictOfficer extends DataObject
{

    /**
     * Human-readable singular name.
     * @var string
     * @config
     */
    private static $singular_name = 'District Officer';

    /**
     * Human-readable pluaral name
     * @var string
     * @config
     */
    private static $plural_name = 'District Officers';

    /**
     * List of database fields. {@link DataObject::$db}
     *
     * @var array
     */
    private static $db = array(
        'Title'        => 'Varchar(128)',
        'Name'         => 'Varchar(128)',
        'PhoneNumber'  => 'Varchar(128)',
        'EmailAddress' => 'Varchar(128)',
        'Biography'    => 'Text',
        'Sort'         => 'Int'
    );

    /**
     * List of one-to-one relationships. {@link DataObject::$has_one}
     *
     * @var array
     */
    private static $has_one = array(
        'Picture'   => 'Image',
        'DistrictOfficersListPage'  => 'DistrictOfficersListPage'
    );

    private static $default_sort = "\"Sort\" ASC";
}