'use strict';

// IIFE - Immediately Invoked Function Expression
(function(yourcode) {

    // The global jQuery object is passed as a parameter
    yourcode(window.jQuery, window, document);

}(function($, window, document) {

        // The $ is now locally scoped
        $(function() {


            // Add JS Class
            $('html')
                .removeClass('no-js')
                .addClass('js');

            $('.open-popup-link').magnificPopup({
                type:'inline',
                midClick: true,
                removalDelay: 500,
                callbacks: {
                    beforeOpen: function() {
                        this.st.mainClass = this.st.el.attr('data-effect');
                    },
                    open: function() {
                        var form = $('form', this.content),
                            formID = form.attr('id'),
                            fieldset = $('fieldset', form),
                            officerID = $(this._lastFocusedEl).attr('data-officer-id'),
                            ministerName = $(this._lastFocusedEl).attr('data-minister-name');

                        if (typeof officerID !== typeof undefined && officerID !== false) {
                            fieldset.append('<input type="hidden" name="OfficerID" value="'+officerID+'" class="hidden" id="'+formID+'_OfficerID">');
                        }

                        if (typeof ministerName !== typeof undefined && ministerName !== false) {
                            fieldset.append('<input type="hidden" name="MinisterName" value="'+ministerName+'" class="hidden" id="'+formID+'_MinisterName">');
                        }
                    },
                    close: function() {
                        $('input[name="OfficerID"]').remove();
                        $('input[name="MinsterName"]').remove();
                    }
                }
            });

            var searchType = $('#search-type'),
                form = $('#ChurchSearch_ChurchSearchForm'),
                radios = $('input[type=radio]', searchType);

            if($('html').hasClass('ie8'))
            {
                searchType.hide();
                form.addClass('search-type-form--all');
            } else {
                if(searchType.length)
                {
                    radios.on('change', function(e){
                        form.toggleClass('search-type-form--toggle');
                    });

                    var location = window.location.search.substr(1).match('location');

                    if(location)
                    {
                        $('#by-location').prop('checked', true);
                        form.addClass('search-type-form--toggle');
                    }
                }
            }





        });

    }
));
