<?php

class JobHolderPage extends Page
{
    /**
     * Human-readable singular name. See {@link DataObject::$singular_name}
     * @var string
     */
    public static $singular_name = 'Job List page';

    /**
     * Human-readable pluaral name. See {@link DataObject::$plural_name}
     * @var string
     */
    public static $plural_name = 'Job Page Lists';

    /**
     * Human-readable description of Page. See {@link DataObject::$description}
     *
     * @access public
     * @static
     * @var string
     */
    public static $description = 'List of job pages';

    //public static $icon = 'articles/images/article-holder.png';

     public static $allowed_children = array(
         'JobPage'
     );

    /**
     * List of database fields. {@link DataObject::$db}
     *
     * @var array
     */
    public static $db = array(
        'PageLength' => 'Int'
    );


    public static $defaults = array(
        'PageLength' => 10
    );

    /**
     * Returns a FieldList with which to create the editing form. {@link SiteTree::getCMSFields()}
     *
     * @return FieldList
     */
    public function getCMSFields()
    {
        $fields = parent::getCMSFields();

        return $fields;
    }

    public function getSettingsFields()
    {
        $fields = parent::getSettingsFields();
        $pageLengthNumericField = new NumericField('PageLength', 'Page length');
        $pageLengthNumericField->setDescription('Number of child pages to display per page.');
        $fields->addFieldToTab('Root.Settings', $pageLengthNumericField);
        return $fields;
    }
}

class JobHolderPage_Controller extends Page_Controller
{

    public function Children()
    {
        if(((int)$this->PageLength) > 0) {
            $children = SiteTree::get()->filter(array('ParentID' => $this->ID));
            $childrenPaginatedList = new PaginatedList($children, $this->request);
            $childrenPaginatedList->setPageLength($this->PageLength);
            return $childrenPaginatedList;
        }
        return parent::Children();
    }
}
