<?php

/**
 * BlogPostTagExtension.
 *
 * @author       Tom Densham <tom.densham@studiobonito.co.uk>
 * @copyright    Studio Bonito Ltd.
 */
class BlogPostTagExtension extends DataExtension
{
    /**
     * List of many-to-many relationships. {@link DataObject::$many_many}
     *
     * @var array
     */
    private static $many_many = array(
        'BlogTags' => 'BlogTag',
    );

    /**
     * @param FieldList $fields
     */
    public function updateCMSFields(FieldList $fields)
    {
        $parentID = $this->owner->ParentID;

        $tagsSource = function ($newItem = null) use ($parentID) {

            // Set parent id if passed new item
            if ($newItem instanceof BlogTag) {
                $newItem->BlogID = $parentID;
                $newItem->write();
            }

            return BlogTag::get()->filter('BlogID', $parentID)->map()->toArray();
        };

        $tagsField = new ListboxField(
            'BlogTags',
            _t('Blog.TAGS', 'Tags'),
            $tagsSource(),
            '',
            null,
            true
        );

        $tagsField->useAddNew('BlogTag', $tagsSource);

        $fields->addFieldToTab('Root.Tags', $tagsField);
    }
}
