<?php

/**
 * BlogTagExtension.
 *
 * @author       Tom Densham <tom.densham@studiobonito.co.uk>
 * @copyright    Studio Bonito Ltd.
 */
class BlogTagExtension extends DataExtension
{
    /**
     * List of database fields. {@link DataObject::$db}
     *
     * @var array
     */
    private static $db = array(
        'TagBaseURLSegment' => 'Varchar(255)',
    );

    /**
     * This defines a one-to-many relationship. It is a map of component name to the remote data class.
     *
     * @var array
     * @config
     */
    private static $has_many = array(
        'BlogTags' => 'BlogTag',
    );

    /**
     * Inserts standard column-values when a DataObject is instantiated.
     *
     * @var array
     * @config
     */
    private static $defaults = array(
        'TagBaseURLSegment' => 'tags',
    );

    /**
     * Ensure that `TagBaseURLSegment` always has a value.
     *
     * @return string
     */
    public function getTagBaseURLSegment()
    {
        $field = $this->owner->getField('TagBaseURLSegment');

        return $field ?: 'tags';
    }

    /**
     * Modifies the FieldList with which to create the main editing form.
     */
    public function updateCMSFields(FieldList $fields)
    {
        $blogTagsField = new GridField('BlogTags', _t('Blog.TAGS', 'Tags'), $this->owner->BlogTags());
        $blogTagsField->setConfig(new GridFieldConfig_RecordEditor());

        $fields->addFieldToTab('Root.Tags', $blogTagsField);
    }

    /**
     * @param FieldList $fields
     */
    public function updateSettingsFields(FieldList $fields)
    {
        $fields->addFieldsToTab(
            'Root.Permalinks',
            array(
                new TextField('TagBaseURLSegment', _t('Blog.TAGBASEURLSEGMENT', 'Tag base')),
            )
        );
    }
}
