<?php

/**
 * BlogControllerTagExtension.
 *
 * @author       Tom Densham <tom.densham@studiobonito.co.uk>
 * @copyright    Studio Bonito Ltd.
 */
class BlogControllerTagExtension extends Extension
{
    /**
     * @var array
     */
    private static $allowed_actions = array(
        'handleTag',
    );

    /**
     *
     */
    public function onBeforeInit()
    {
        $categoryBaseURLSegment = $this->owner->TagBaseURLSegment;
        $this->owner->set_stat('url_handlers', array("$categoryBaseURLSegment/\$Name!" => 'handleTag'));
    }

    /**
     * @param SS_HTTPRequest $request
     * @param DataModel|null $model
     * @return mixed
     */
    public function handleTag(SS_HTTPRequest $request, DataModel $model = null)
    {
        if ($name = $request->param('Name')) {
            $tag = BlogTag::get()->filter(array('URLSegment' => $name))->first();

            if ($tag) {
                $this->owner->setBlogPosts($tag->BlogPosts()->sort('Published', 'DESC'));
            }
        }

        return $this->owner->render(array('Title' => "{$this->owner->Title} - {$tag->Title}"));
    }
}
