<?php

/**
 * BlogTest.
 *
 * @author       Tom Densham <tom.densham@studiobonito.co.uk>
 * @copyright    Studio Bonito Ltd.
 */
class BlogTest extends SapphireTest
{
    protected static $fixture_file = 'blog/tests/BlogTest.yml';

    public function testGetBlogPosts()
    {
        $blog = $this->objFromFixture('Blog', 'blog');

        $this->assertNotNull($blog->getBlogPosts());
        $this->assertEquals(3, $blog->getBlogPosts()->Count());
    }

    public function testGetArchivedBlogPostsWithYear()
    {
        $blog = $this->objFromFixture('Blog', 'blog');

        $year = 2014;

        $this->assertNotNull($blog->getArchivedBlogPosts($year));
        $this->assertEquals(1, $blog->getArchivedBlogPosts($year)->Count());
    }

    public function testGetArchivedBlogPostsWithMonth()
    {
        $blog = $this->objFromFixture('Blog', 'blog');

        $year = 2015;
        $month = 1;

        $this->assertNotNull($blog->getArchivedBlogPosts($year, $month));
        $this->assertEquals(2, $blog->getArchivedBlogPosts($year, $month)->Count());
    }

    public function testGetArchivedBlogPostsWithDay()
    {
        $blog = $this->objFromFixture('Blog', 'blog');

        $year = 2015;
        $month = 1;
        $day = 2;

        $this->assertNotNull($blog->getArchivedBlogPosts($year, $month, $day));
        $this->assertEquals(1, $blog->getArchivedBlogPosts($year, $month, $day)->Count());
    }
}