<?php

/**
 * GridField component that provides a link to edit SiteTree records.
 *
 * @author       Tom Densham <tom.densham@studiobonito.co.uk>
 * @copyright    Studio Bonito Ltd.
 */
class GridFieldSiteTreeEditButton extends GridFieldEditButton
{
    /**
     * @param GridField  $gridField
     * @param DataObject $record
     * @param string     $columnName
     *
     * @return HTMLText HTML content for the column
     */
    public function getColumnContent($gridField, $record, $columnName)
    {
        $data = new ArrayData(array('Link' => $record->CMSEditLink()));

        return $data->renderWith('GridFieldEditButton');
    }
} 