<?php

/**
 * GridField component that provides a button for adding SiteTree records.
 *
 * @author       Tom Densham <tom.densham@studiobonito.co.uk>
 * @copyright    Studio Bonito Ltd.
 */
class GridFieldSiteTreeAddNewButton extends GridFieldAddNewButton
{
    /**
     * @param GridField $gridField
     *
     * @return array
     */
    public function getHTMLFragments($gridField)
    {
        $singleton = singleton($gridField->getModelClass());

        if (!$singleton->canCreate()) {
            return array();
        }

        if (!$this->buttonName) {
            $objectName = $singleton->i18n_singular_name();
            $this->buttonName = _t('GridField.Add', 'Add {name}', array('name' => $objectName));
        }

        $controller = CMSPageAddController::create();

        $data = new ArrayData(
            array(
                'NewLink'    => $controller->Link() . '?ParentID=' . Controller::curr()->currentPageID(),
                'ButtonName' => $this->buttonName,
            )
        );

        return array(
            $this->targetFragment => $data->renderWith('GridFieldAddNewbutton'),
        );
    }
}