<?php

/**
 * Blog extension that provides a method for excluding records from the SiteTree.
 *
 * @author       Tom Densham <tom.densham@studiobonito.co.uk>
 * @copyright    Studio Bonito Ltd.
 */
class BlogSiteTreeFilterExtension extends Hierarchy
{
    /**
     * @param bool $showAll
     *
     * @return SS_List
     */
    public function stageChildren($showAll = false)
    {
        $staged = parent::stageChildren($showAll);

        return $this->excludeChildren($staged);
    }

    /**
     * @param bool $showAll
     * @param bool $onlyDeletedFromStage
     *
     * @return SS_List
     */
    public function liveChildren($showAll = false, $onlyDeletedFromStage = false)
    {
        $staged = parent::liveChildren($showAll, $onlyDeletedFromStage);

        return $this->excludeChildren($staged);
    }

    /**
     * @param SS_List $staged
     *
     * @return SS_List
     */
    protected function excludeChildren($staged)
    {
        $controller = Controller::curr();
        $actions = array('treeview', 'listview', 'getsubtree');
        if ($controller->class === 'CMSPagesController' && in_array($controller->getAction(), $actions)) {
            // Filter the SiteTree
            return $staged->exclude('ClassName', $this->owner->getExcludedSiteTreeClassNames());
        }

        return $staged;
    }
}