<?php

/**
 * Blog post content page.
 *
 * @author       Tom Densham <tom.densham@studiobonito.co.uk>
 * @copyright    Studio Bonito Ltd.
 */
class BlogPost extends Page
{
    /**
     * Indicates what kind of children this page type can have. {@link SiteTree::$allowed_children}
     *
     * @config
     * @var array
     */
    private static $allowed_children = array();

    /**
     * The default parent class for this page. {@link SiteTree::$default_parent}
     *
     * @config
     * @var string
     */
    private static $default_parent = 'Blog';

    /**
     * Controls whether a page can be in the root of the site tree. {@link SiteTree::$can_be_root}
     *
     * @config
     * @var bool
     */
    private static $can_be_root = false;

    /**
     * Configure the form field used for editing the Published database field.
     *
     * @config
     * @var string
     */
    private static $published_field = 'dateandtime';

    /**
     * Show {@link BlogPost}s as children in the {@link SiteTree} or in a {@link GridField} on the Blog.
     *
     * @config
     * @var bool
     */
    private static $show_in_sitetree = true;

    /**
     * List of database fields. {@link DataObject::$db}
     *
     * @var array
     */
    private static $db = array(
        'Author'    => 'Varchar(100)',
        'Published' => 'SS_Datetime'
    );

    /**
     * Sets the Date field to the current date.
     */
    public function populateDefaults() {
        $this->Published = date('Y-m-d H:i:s');
        parent::populateDefaults();
    }

    /**
     * Override Author getter to set default value as calling `Member::currentUser()`
     * from `BlogPost::populateDefaults()` is unsafe.
     *
     * @return mixed|string
     */
    public function getAuthor()
    {
        $author = $this->getField('Author');
        if (empty($author)) {
            $member = Member::currentUser();
            if ($member && $member->exists()) {
                return $member->getName();
            }
        }

        return $author;
    }

    /**
     * Returns a FieldList with which to create the main editing form. {@link DataObject::getCMSFields()}
     *
     * @codeCoverageIgnore
     *
     * @return FieldList The fields to be displayed in the CMS.
     */
    public function getCMSFields()
    {
        $fields = parent::getCMSFields();

        $config = $this->config();

        $authorField = TextField::create('Author', _t('Blog.AUTHOR', 'Author'));

        if ($config->get('editable_author') == false) {
            $authorField = $authorField->performReadonlyTransformation();
        }

        switch ($config->get('published_field')) {
            case 'dateonly':
                $publishedField = DateField::create('Published', _t('Blog.PUBLISHED', 'Publish on'));
                $publishedField->setConfig('showcalendar', true);
                break;
            case 'dateandtime':
            default:
                $publishedField = DatetimeField::create('Published', _t('Blog.PUBLISHED', 'Publish on'));
                $publishedField->getDateField()->setConfig('showcalendar', true);
                break;
        }

        $fields->addFieldsToTab(
            'Root.Main',
            array(
                $authorField,
                $publishedField
            ),
            'Content'
        );

        $this->extend('updateBlogPostFields', $fields);

        return $fields;
    }
}

/**
 * Controller for blog post page.
 *
 * @author       Tom Densham <tom.densham@studiobonito.co.uk>
 * @copyright    Studio Bonito Ltd.
 */
class BlogPost_Controller extends Page_Controller
{

}