<?php
/**
 * BonitoLeftAndMain.
 *
 * @author Tom Densham <tom.densham@studiobonito.co.uk>
 * @copyright (c) 2013, Studio Bonito Ltd.
 * @version 1.0
 */

class BonitoLeftAndMain extends LeftAndMainExtension {

    public function init() {
        Requirements::css('bonito-brand/css/BonitoLeftAndMain.css');

        // unique identifier for this item. Will have an ID of Menu-$ID
        $id = 'LinkToBonito';

        // your 'nice' title
        $title = 'Crafted by Bonito';

        // the link you want to item to go to
        $link = 'http://www.studiobonito.co.uk/';

        // priority controls the ordering of the link in the stack. The
        // lower the number, the lower in the list
        $priority = -100;

        // Add your own attributes onto the link. In our case, we want to
        // open the link in a new window (not the original)
        $attributes = array(
            'target' => '_blank'
        );

        CMSMenu::add_link($id, $title, $link, $priority, $attributes);
    }
}