<?php

/**
 * BonitoMemberLoginForm.
 *
 * @author Tom Densham <tom.densham@studiobonito.co.uk>
 * @copyright (c) 2013, Studio Bonito Ltd.
 * @version 1.0
 */
class BonitoMemberLoginForm extends MemberLoginForm {

    public function __construct($controller, $name, $fields = null, $actions = null, $checkCurrentUser = true)
    {
        parent::__construct($controller, $name, $fields, $actions, $checkCurrentUser);

        if($this->Actions()->hasField('forgotPassword')) {
            $this->Actions()->removeByName('forgotPassword');
            $this->Actions()->push(new LiteralField(
                'forgotPassword',
                '<span id="ForgotPassword"><a href="Security/lostpassword">'
                . _t('Member.BUTTONLOSTPASSWORD', "I've lost my password") . '</a></span>'
            ));
        }
    }
}